﻿import mx.core.UIComponent;
import mx.controls.ComboBox;
import mx.controls.Button;
import Counter;
class TwoStones extends UIComponent {
	var X, Y:Array;
	var r1, r2, b1, b2:MovieClip;
	var x0:Number = 0;
	var y0:Number = 0;
	var startButton:Button;
	var initPlace, goFirst:ComboBox;
	var first:Boolean = true; // player (red) goes first
	var Top:Boolean = true; // player (red) start at the top
	var note:TextField;
	var hole:Number = 2;
	var game:Boolean = false;
	var end:Boolean = false;
	var redTurn:Boolean = true;
	function TwoStones() {
		startButton = this["startButton"];
		initPlace = this["initPlace"];
		goFirst = this["goFirst"];
		doLater(this, "initialize");
		note = this["note"];
		note.text = "Start\na new\ngame!";
		X = new Array();
		Y = new Array();
		X[0] = x0; Y[0] = y0;				// 0     1
		X[1] = x0 + 200; Y[1] = y0;			//	  2
		X[2] = x0 + 100; Y[2] = y0 + 100;	// 3     4
		X[3] = x0; Y[3] = y0 + 200;
		X[4] = x0 + 200; Y[4] = y0 + 200;
	}
	function initialize() : Void{
		startButton.addEventListener("click", this);
		initPlace.addEventListener("change", this);
		goFirst.addEventListener("change", this);
	}
	function click() : Void{
		clearCounters();
		game = !game;
		if (game) { // start the game
			startButton.label = "Restart game";
			end = false;
			redTurn = first;
			makeGame(Top);
			playGame();
		}
		else { // stop the game
			hole = 2;
			note.text = "Start\na new\ngame!";
			startButton.label = "Start game";
		}
		initPlace.enabled = !game;
		goFirst.enabled = !game;
	}
	function change() {
		if (initPlace.selectedIndex == 0) {
			Top = true;
		}
		else {
			Top = false;
		}
		if (goFirst.selectedIndex == 0) {
			first = true;
		}
		else {
			first = false;
		}
	}
	function makeGame(atTop:Boolean) {
		var shift,pos:Number;
		if (atTop) {
			shift = 0;
			pos = 0;
		}
		else {
			shift = 200;
			pos = 3;
		}
		r1 = attachMovie("RedCounter", "r1", 1, {_x:X[0], _y:(Y[0]+shift), position:(0+pos), state:false});
		r2 = attachMovie("RedCounter", "r2", 2, {_x:X[1], _y:(Y[1]+shift), position:(1+pos), state:false});
		b1 = attachMovie("BlueCounter", "b1", 3, {_x:X[3], _y:(Y[3]-shift), position:(3-pos), state:false});
		b2 = attachMovie("BlueCounter", "b2", 4, {_x:X[4], _y:(Y[4]-shift), position:(4-pos), state:false});
	}
	function changeTurn(){
		if (redTurn) {
			note.textColor = 0xFF0000;
			note.text = "Your \nturn!"
		}
		else {
			note.textColor = 0x0000FF;
			note.text = "Computers \nturn!"
		}
		redTurn = !redTurn;
	}
	function clearCounters() {
		r1.removeMovieClip();
		r2.removeMovieClip();
		b1.removeMovieClip();
		b2.removeMovieClip();
	}
	function deactAll(){
		r1.state = false;
		r2.state = false;
		b1.state = false;
		b2.state = false;
	}
	function playGame(){
		deactAll();
		if (redTurn){
			r1.ifCanGo();
			r2.ifCanGo();
			if (!r1.state && ! r2.state) {
				note.text = "I win\nthis time";
				end = true;
			}
		}
		else {
			b1.ifCanGo();
			b2.ifCanGo();
			if (!b1.state && ! b2.state) {
				note.text = "Well done!\nYou won!";
				end = true;
			}
			else {
				computerPlay();
			}
		}
		if (!end) {
			changeTurn();
		}
	}
	function computerPlay() {
		if (b1.state && b2.state) {
			if (randomChoice()) {
				b1.counterOnRelease();
			}
			else {
				b2.counterOnRelease();
			}
		}
		else if (b1.state) {
			b1.counterOnRelease();
		}
		else {
			b2.counterOnRelease();
		}
	}
	function randomChoice() : Boolean {
		var result:Boolean;
		if (Math.random() <= 0.5) {
			result = false;
		}
		else {
			result = true;
		}
		return result;
	}
}